/**
 *  Pages Authentication
 */

'use strict';
const formAuthentication = document.querySelector('#formAuthentication');

document.addEventListener('DOMContentLoaded', function (e) {
  (function () {
    // Form validation for Add new record
    if (formAuthentication) {
      const fv = FormValidation.formValidation(formAuthentication, {
        fields: {
          username: {
            validators: {
              notEmpty: {
                message: 'Silakan masukkan username'
              },
              stringLength: {
                min: 6,
                message: 'Username harus 6 karakter atau lebih'
              }
            }
          },
          email: {
            validators: {
              notEmpty: {
                message: 'Silakan masukkan email Anda'
              },
              emailAddress: {
                message: 'Silakan masukkan alamat email yang valid'
              }
            }
          },
          'email-username': {
            validators: {
              notEmpty: {
                message: 'Silakan masukkan email / username'
              },
              stringLength: {
                min: 6,
                message: 'Username harus 6 karakter atau lebih'
              }
            }
          },
          password: {
            validators: {
              notEmpty: {
                message: 'Silakan masukkan password Anda'
              },
              stringLength: {
                min: 6,
                message: 'Password harus 6 karakter atau lebih'
              }
            }
          },
          'confirm-password': {
            validators: {
              notEmpty: {
                message: 'Silakan konfirmasi password'
              },
              identical: {
                compare: function () {
                  return formAuthentication.querySelector('[name="password"]').value;
                },
                message: 'Password dan konfirmasi password tidak sama'
              },
              stringLength: {
                min: 6,
                message: 'Password harus 6 karakter atau lebih'
              }
            }
          },
          terms: {
            validators: {
              notEmpty: {
                message: 'Silakan setujui peraturan dan persyaratannya'
              }
            }
          }
        },
        plugins: {
          trigger: new FormValidation.plugins.Trigger(),
          bootstrap5: new FormValidation.plugins.Bootstrap5({
            eleValidClass: '',
            rowSelector: '.mb-3'
          }),
          submitButton: new FormValidation.plugins.SubmitButton(),

          defaultSubmit: new FormValidation.plugins.DefaultSubmit(),
          autoFocus: new FormValidation.plugins.AutoFocus()
        },
        init: instance => {
          instance.on('plugins.message.placed', function (e) {
            if (e.element.parentElement.classList.contains('input-group')) {
              e.element.parentElement.insertAdjacentElement('afterend', e.messageElement);
            }
          });
        }
      });
    }

    //  Two Steps Verification
    const numeralMask = document.querySelectorAll('.numeral-mask');

    // Verification masking
    if (numeralMask.length) {
      numeralMask.forEach(e => {
        new Cleave(e, {
          numeral: true
        });
      });
    }
  })();
});
